/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package salesApplication;

import datasource.DataSource;
import datasource.FileDataSource;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;


/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class TestPriceList {
    public static void main(String[] args) {
        DataSource ds = new FileDataSource();
        PriceList demo = ds.retrieveList("Demo"); 
        //Use the Paths helper class to return the Path 
        //for the "mydatasource" file.
        Path datafile = Paths.get("mydatasource");
        System.out.println("Path: "+datafile);
        //Print out the location of my file
        System.out.println("Location: "+datafile.toAbsolutePath());
        System.out.println("Exists? "+Files.exists(datafile));
    }
}
